<?php
/* Copyright (C) 2006-2011 Laurent Destailleur <eldy@users.sourceforge.net>
 * Copyright (C) 2024		Frédéric France			<frederic.france@free.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 * or see https://www.gnu.org/
 */

/**
 *      \file       htdocs/core/modules/security/generate/modGeneratePassNone.class.php
 *      \ingroup    core
 *      \brief      File to manage no password generation.
 */

require_once DOL_DOCUMENT_ROOT.'/core/modules/security/generate/modules_genpassword.php';


/**
 *	Class to generate a password according to rule 'no password'
 */
class modGeneratePassNone extends ModeleGenPassword
{
	/**
	 * @var string ID
	 */
	public $id;

	public $picto = 'fa-keyboard';

	/**
	 *	Constructor
	 *
	 *  @param		DoliDB		$db			Database handler
	 *	@param		Conf		$conf		Handler de conf
	 *	@param		Translate	$langs		Handler de langue
	 *	@param		User		$user		Handler du user connected
	 */
	public function __construct($db, $conf, $langs, $user)
	{
		$this->id = "none";
		$this->length = '0';
		$this->length2 = 0;

		$this->db = $db;
		$this->conf = $conf;
		$this->langs = $langs;
		$this->user = $user;
	}

	/**
	 *		Return description of module
	 *
	 *      @return     string      Description of text
	 */
	public function getDescription()
	{
		global $langs;
		return $langs->trans("PasswordGenerationNone");
	}

	/**
	 * 		Return an example of password generated by this module
	 *
	 *      @return     string      Example of password
	 */
	public function getExample()
	{
		return $this->langs->trans("None");
	}

	/**
	 * 		Build new password
	 *
	 *      @return     string      Return a new generated password
	 */
	public function getNewGeneratedPassword()
	{
		return "";
	}

	/**
	 * 	Validate a password.
	 * 	This function is called by User->setPassword() and internally to validate that the password matches the constraints.
	 *
	 *	@param		string	$password	Password to check
	 *  @return     int					0 if KO, >0 if OK
	 */
	public function validatePassword($password)
	{
		dol_syslog("modGeneratePassNone::validatePassword");

		return 1;
	}
}
